import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/style.dart';
import 'package:viser_remit/data/controller/account/change_password_controller.dart';
import 'package:viser_remit/data/repo/account/change_password_repo.dart';
import 'package:viser_remit/data/services/api_client.dart';
import 'package:viser_remit/view/components/app-bar/custom_appbar.dart';
import 'package:viser_remit/view/screens/account/change-password/widget/change_password_form.dart';

import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/util.dart';

class ChangePasswordScreen extends StatefulWidget {
  const ChangePasswordScreen({Key? key}) : super(key: key);

  @override
  State<ChangePasswordScreen> createState() => _ChangePasswordScreenState();
}

class _ChangePasswordScreenState extends State<ChangePasswordScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(ChangePasswordRepo(apiClient: Get.find()));
    Get.put(ChangePasswordController(changePasswordRepo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      Get.find<ChangePasswordController>().clearData();
    });
  }

  @override
  void dispose() {
    Get.find<ChangePasswordController>().clearData();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      color: MyColor.primaryColor,
      child: SafeArea(
        child: Scaffold(
          backgroundColor: MyColor.getScreenBgColor(),
          appBar: CustomAppBar(isShowBackBtn: true, title: MyStrings.changePassword.tr, bgColor: MyColor.getAppBarColor()),
          body: GetBuilder<ChangePasswordController>(
            builder: (controller) {
              return SingleChildScrollView(
                padding: const EdgeInsets.symmetric(horizontal: Dimensions.space16, vertical: Dimensions.space20),
                child: Container(
                  padding: const EdgeInsetsDirectional.symmetric(horizontal: Dimensions.space20, vertical: Dimensions.space5),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(Dimensions.space10),
                    color: MyColor.getCardBgColor(),
                    boxShadow: MyUtils.getCardShadow(),
                  ),
                  child: Padding(
                    padding: const EdgeInsets.symmetric(vertical: 45, horizontal: 0),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          MyStrings.createNewPassword.tr,
                          style: regularExtraLarge.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w500),
                        ),
                        const SizedBox(height: 12),
                        Padding(
                          padding: const EdgeInsetsDirectional.only(end: 50),
                          child: Text(
                            MyStrings.createPasswordSubText.tr,
                            style: regularDefault.copyWith(color: MyColor.getTextColor().withOpacity(0.8)),
                          ),
                        ),
                        const SizedBox(height: 50),
                        const ChangePasswordForm()
                      ],
                    ),
                  ),
                ),
              );
            },
          ),
        ),
      ),
    );
  }
}
